module.exports = {
    name: "Discord Audio Player [Dependency]",

    description: "Starts the Discord Audio Player dependency required for other blocks to work.",

    category: "Dependencies",

    inputs: [],

    options: [
        {
            "id": "disableYouTubeExtractor",
            "name": "Disable YouTube Extractor",
            "description": "Description: If you want to disable the YouTube Extractor.",
            "type": "CHECKBOX"
        }
    ],

    outputs: [],

    async init(DBB) {
        const { readFileSync } = require("fs");
        const values = JSON.parse(readFileSync(DBB.File.paths.workspaces)).map((item) => { return item.blocks.filter(x => x.name == 'discord_audio_player_dependency') }).filter(x => x[0]).map(x => x.map(x => x.options).flat()).flat()[0];
        const disableYouTubeExtractor = values ? values.disableYouTubeExtractor : false;

        try {
            const success = await DBB.Dependencies.PackageManager?.requires(
                { name: "discord-player", version: "latest" },
                { name: "@discord-player/extractor", version: "latest" },
                { name: "ffmpeg-static", version: "latest" },
                { name: "discord-player-youtubei", version: "latest" }
            )
            if (!success) console.log("Failed to install dependencies! (Discord Audio Player Dependency)")
        } catch (e) {
            console.log(e)
        }

        const module = require("discord-player");
        if (!DBB.Dependencies.DiscordPlayer) DBB.Dependencies.DiscordPlayer = {}
        DBB.Dependencies.DiscordPlayer.module = require("discord-player")

        const { DefaultExtractors } = require("@discord-player/extractor");

        process.env.FFMPEG_PATH = require("ffmpeg-static")
        const player = new module.Player(DBB.DiscordJS.client);
        const { YoutubeiExtractor } = require("discord-player-youtubei")
        await player.extractors.loadMulti(DefaultExtractors);
        if (disableYouTubeExtractor) DBB.Core.console("INFO", "YouTube Extractor Disabled!");
        if (!disableYouTubeExtractor) await player.extractors.register(YoutubeiExtractor);
        DBB.Dependencies.DiscordPlayer.player = player;
        require("youtubei.js").Log.setLevel(require("youtubei.js").Log.Level.NONE)
    }
}